import { Plugin } from "..";
import { marked } from "marked";
import { parseMetadata } from "./markdown-metadata";

export default class MarkdownCompiler extends Plugin {
    build: undefined;

    name = "markdown-compiler";
    rewriteTriggers = ["md"]
    renameTo = "html"
    longLasting = false;
    
    async rewriteFile(file: string, filePath: string) {
        let text = file;
        const metadata = parseMetadata(text);
        if(metadata) { 
            let textSplit = text.split('\n');
            textSplit.splice(0, Object.keys(metadata).length);
            textSplit.unshift(metadata.title)
            text = textSplit.join("\n");
        }
        return await marked.parse(text); 
    }
}